/*
 * Decompiled with CFR 0.152.
 */
package com.sinaapp.msdxblog.apkUtil.utils;

import com.sinaapp.msdxblog.apkUtil.Version;
import com.sinaapp.msdxblog.apkUtil.entity.ApkInfo;
import com.sinaapp.msdxblog.apkUtil.entity.ImpliedFeature;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ApkUtil {
    public static final String VERSION_CODE = "versionCode";
    public static final String VERSION_NAME = "versionName";
    public static final String SDK_VERSION = "sdkVersion";
    public static final String TARGET_SDK_VERSION = "targetSdkVersion";
    public static final String USES_PERMISSION = "uses-permission";
    public static final String APPLICATION_LABEL = "application-label";
    public static final String APPLICATION_ICON = "application-icon";
    public static final String USES_FEATURE = "uses-feature";
    public static final String USES_IMPLIED_FEATURE = "uses-implied-feature";
    public static final String SUPPORTS_SCREENS = "supports-screens";
    public static final String SUPPORTS_ANY_DENSITY = "supports-any-density";
    public static final String DENSITIES = "densities";
    public static final String PACKAGE = "package";
    public static final String APPLICATION = "application:";
    public static final String LAUNCHABLE_ACTIVITY = "launchable-activity";
    private ProcessBuilder mBuilder = new ProcessBuilder(new String[0]);
    private static final String SPLIT_REGEX = "(: )|(=')|(' )|'";
    private static final String FEATURE_SPLIT_REGEX = "(:')|(',')|'";
    private String mAaptPath = "lib/aapt";

    public ApkUtil() {
        this.mBuilder.redirectErrorStream(true);
    }

    public ApkInfo getApkInfo(String apkPath) throws Exception {
        Process process = this.mBuilder.command(this.mAaptPath, "d", "badging", apkPath).start();
        InputStream is = null;
        is = process.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf8"));
        String tmp = br.readLine();
        try {
            if (tmp == null || !tmp.startsWith(PACKAGE)) {
                throw new Exception("\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u6b63\u5e38\u89e3\u6790APK\u5305\u3002\u8f93\u51fa\u7ed3\u679c\u4e3a:\n" + tmp + "...");
            }
            ApkInfo apkInfo = new ApkInfo();
            do {
                this.setApkInfoProperty(apkInfo, tmp);
            } while ((tmp = br.readLine()) != null);
            ApkInfo apkInfo2 = apkInfo;
            return apkInfo2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            process.destroy();
            ApkUtil.closeIO(is);
            ApkUtil.closeIO(br);
        }
    }

    private void setApkInfoProperty(ApkInfo apkInfo, String source) {
        if (source.startsWith(PACKAGE)) {
            this.splitPackageInfo(apkInfo, source);
        } else if (source.startsWith(LAUNCHABLE_ACTIVITY)) {
            apkInfo.setLaunchableActivity(this.getPropertyInQuote(source));
        } else if (source.startsWith(SDK_VERSION)) {
            apkInfo.setSdkVersion(this.getPropertyInQuote(source));
        } else if (source.startsWith(TARGET_SDK_VERSION)) {
            apkInfo.setTargetSdkVersion(this.getPropertyInQuote(source));
        } else if (source.startsWith(USES_PERMISSION)) {
            apkInfo.addToUsesPermissions(this.getPropertyInQuote(source));
        } else if (source.startsWith(APPLICATION_LABEL)) {
            apkInfo.setApplicationLable(this.getPropertyInQuote(source));
        } else if (source.startsWith(APPLICATION_ICON)) {
            apkInfo.addToApplicationIcons(this.getKeyBeforeColon(source), this.getPropertyInQuote(source));
        } else if (source.startsWith(APPLICATION)) {
            String[] rs = source.split("( icon=')|'");
            apkInfo.setApplicationIcon(rs[rs.length - 1]);
        } else if (source.startsWith(USES_FEATURE)) {
            apkInfo.addToFeatures(this.getPropertyInQuote(source));
        } else if (source.startsWith(USES_IMPLIED_FEATURE)) {
            apkInfo.addToImpliedFeatures(this.getFeature(source));
        }
    }

    private ImpliedFeature getFeature(String source) {
        String[] result = source.split(FEATURE_SPLIT_REGEX);
        ImpliedFeature impliedFeature = new ImpliedFeature(result[1], result[2]);
        return impliedFeature;
    }

    private String getPropertyInQuote(String source) {
        int index = source.indexOf("'") + 1;
        return source.substring(index, source.indexOf(39, index));
    }

    private String getKeyBeforeColon(String source) {
        return source.substring(0, source.indexOf(58));
    }

    private void splitPackageInfo(ApkInfo apkInfo, String packageSource) {
        String[] packageInfo = packageSource.split(SPLIT_REGEX);
        apkInfo.setPackageName(packageInfo[2]);
        apkInfo.setVersionCode(packageInfo[4]);
        apkInfo.setVersionName(packageInfo[6]);
    }

    public static final void closeIO(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        try {
            String demo = "D:/works/app/ApplicationAssistant.apk";
            if (args.length > 0) {
                if (args[0].equals("-version") || args[0].equals("-v")) {
                    System.out.println("ApkUtil   -by Geek_Soledad");
                    System.out.println("Version:" + Version.getVersion());
                    return;
                }
                demo = args[0];
            }
            ApkInfo apkInfo = new ApkUtil().getApkInfo(demo);
            System.out.println(apkInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getmAaptPath() {
        return this.mAaptPath;
    }

    public void setmAaptPath(String mAaptPath) {
        this.mAaptPath = mAaptPath;
    }

    protected List<String> exeCommand(String command) {
        ArrayList<String> arrayList;
        BufferedReader br;
        InputStream is;
        block7: {
            Process process = null;
            is = null;
            br = null;
            try {
                String tmp;
                process = this.mBuilder.command(command).start();
                is = process.getInputStream();
                br = new BufferedReader(new InputStreamReader(is, "utf8"));
                ArrayList<String> results = new ArrayList<String>();
                while ((tmp = br.readLine()) != null) {
                    results.add(tmp);
                }
                arrayList = results;
                if (process == null) break block7;
                process.destroy();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
                ApkUtil.closeIO(is);
                ApkUtil.closeIO(br);
            }
        }
        ApkUtil.closeIO(is);
        ApkUtil.closeIO(br);
        return arrayList;
    }
}

