/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import VO.AppActivity;
import VO.BugDetail;
import VO.ExceptionDesc;
import VO.Task;
import VO.TestAction;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class action {
    public static String readTestData(String path) throws IOException {
        String tempStr;
        File file = new File(path);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuilder sbf = new StringBuilder();
        while ((tempStr = reader.readLine()) != null) {
            sbf.append(tempStr);
        }
        reader.close();
        return sbf.toString();
    }

    public static ArrayList<TestAction> getTestAction(String data) {
        String[] actions = data.split("}");
        for (int i = 0; i < actions.length; ++i) {
            int n = i;
            actions[n] = actions[n] + "}";
            actions[i] = actions[i].replace("\\n", "");
        }
        ArrayList<TestAction> testActions = new ArrayList<TestAction>();
        for (int i = 0; i < actions.length; ++i) {
            testActions.add((TestAction)JSON.parseObject((String)actions[i], TestAction.class));
        }
        action.addDescription(testActions);
        return testActions;
    }

    public static void addDescription(ArrayList<TestAction> testActions) {
        int length = testActions.size();
        for (int i = 0; i < length; ++i) {
            TestAction action2 = testActions.get(i);
            action2.message = action2.message.replace(",", "");
            if (action2.type.equals("CLICK")) {
                action2.desc = action2.message.contains("Click Cancel button") ? "\u93bf\u5d84\u7d94" + (i + 1) + " : \u9410\u7470\u56ae\u5bee\u572d\u7365\u9359\u6828\u79f7\u93b8\u5910\u6333" : (action2.message.contains("Click Return button") ? "\u93bf\u5d84\u7d94" + (i + 1) + " : \u9410\u7470\u56ae\u6769\u65bf\u6d16\u95bf\ufffd" : "\u93bf\u5d84\u7d94" + (i + 1) + " : \u9410\u7470\u56ae; \u6d63\u5d87\u7586 \u951b\ufffd" + action2.message.split(" ")[2]);
                if (action2.activityAfterAction.equals(action2.activityBeforeAction)) continue;
                action2.desc = action2.desc + "; \u6924\u7538\u6f70\u74ba\u5ba0\u6d46 : " + action2.activityBeforeAction + " -> " + action2.activityAfterAction;
                continue;
            }
            action2.desc = "\u93bf\u5d84\u7d94" + (i + 1) + " : \u6748\u64b3\u53c6; \u6d63\u5d87\u7586 \u951b\ufffd" + action2.message.split(" ")[1] + "; \u934a\ufffd \u951b\ufffd " + action2.message.split(" ")[4];
        }
    }

    public static ArrayList<AppActivity> getAppActivity(ArrayList<TestAction> testActions) {
        int length = testActions.size();
        ArrayList<AppActivity> activities = new ArrayList<AppActivity>();
        for (int i = 0; i < length; ++i) {
            AppActivity temp;
            TestAction action2 = testActions.get(i);
            AppActivity appActivity = new AppActivity(action2.activityBeforeAction);
            if (!activities.contains(appActivity)) {
                activities.add(appActivity);
            } else {
                appActivity = activities.get(activities.indexOf(appActivity));
            }
            if (action2.activityBeforeAction.equals(action2.activityAfterAction) || action2.activityAfterAction.equals(".Launcher") || appActivity.nextActivity.contains(temp = new AppActivity(action2.activityAfterAction))) continue;
            if (activities.contains(temp)) {
                appActivity.nextActivity.add(activities.get(activities.indexOf(temp)));
                continue;
            }
            activities.add(temp);
            appActivity.nextActivity.add(temp);
        }
        return activities;
    }

    public static void bfs(Set<AppActivity> set, ArrayList<String> load, LinkedList<AppActivity> queue) {
        while (queue.size() > 0) {
            AppActivity current = queue.poll();
            if (set.contains(current)) continue;
            set.add(current);
            String currentLoad = current.last + "->" + current.name;
            load.add(currentLoad);
            for (int i = 0; i < current.nextActivity.size(); ++i) {
                AppActivity temp = (AppActivity)current.nextActivity.get(i);
                if (set.contains(temp) || queue.contains(temp)) continue;
                temp.last = currentLoad;
                queue.addLast(temp);
            }
        }
    }

    public static Map<String, LinkedList<TestAction>> getShortestPath(ArrayList<AppActivity> activities, ArrayList<TestAction> testActions) {
        AppActivity enter = activities.get(0);
        HashSet<AppActivity> set = new HashSet<AppActivity>();
        ArrayList load = new ArrayList();
        LinkedList<AppActivity> queue = new LinkedList<AppActivity>();
        for (int i = 0; i < enter.nextActivity.size(); ++i) {
            AppActivity temp = (AppActivity)enter.nextActivity.get(i);
            temp.last = enter.name;
            queue.addLast(temp);
        }
        set.add(enter);
        action.bfs(set, load, queue);
        String first = (String)load.get(0);
        TestAction firstAction = null;
        for (int i = 0; i < testActions.size(); ++i) {
            if (!testActions.get((int)i).activityBeforeAction.equals(first.split("->")[0]) || !testActions.get((int)i).activityAfterAction.equals(first.split("->")[1])) continue;
            firstAction = testActions.get(i);
            break;
        }
        LinkedHashMap map = new LinkedHashMap();
        LinkedList<TestAction> linkedList = new LinkedList<TestAction>();
        linkedList.addLast(firstAction);
        map.put(first, linkedList);
        for (int i = 1; i < load.size(); ++i) {
            int j;
            String[] temp = ((String)load.get(i)).split("->");
            String last = "";
            if (temp.length == 2) {
                TestAction testAction = null;
                for (int j2 = 0; j2 < testActions.size(); ++j2) {
                    if (!testActions.get((int)j2).activityBeforeAction.equals(temp[0]) || !testActions.get((int)j2).activityAfterAction.equals(temp[1])) continue;
                    testAction = testActions.get(j2);
                    break;
                }
                LinkedList<TestAction> linkedList1 = new LinkedList<TestAction>();
                linkedList1.addLast(testAction);
                map.put((String)load.get(i), linkedList1);
                continue;
            }
            for (int j3 = 0; j3 < temp.length - 2; ++j3) {
                last = last + temp[j3] + "->";
            }
            last = last + temp[temp.length - 2];
            LinkedList lastList = (LinkedList)map.get(last);
            LinkedList currentList = new LinkedList();
            for (j = 0; j < lastList.size(); ++j) {
                currentList.addLast(lastList.get(j));
            }
            for (j = 0; j < testActions.size(); ++j) {
                if (!testActions.get((int)j).activityBeforeAction.equals(temp[temp.length - 2]) || !testActions.get((int)j).activityAfterAction.equals(temp[temp.length - 1])) continue;
                currentList.addLast(testActions.get(j));
                break;
            }
            map.put((String)load.get(i), currentList);
        }
        Set keySet = map.keySet();
        Iterator iterator = keySet.iterator();
        HashMap<String, LinkedList<TestAction>> result = new HashMap<String, LinkedList<TestAction>>();
        while (iterator.hasNext()) {
            String temp = (String)iterator.next();
            String[] array = temp.split("->");
            String newKey = array[array.length - 1];
            result.put(newKey, (LinkedList<TestAction>)map.get(temp));
        }
        return result;
    }

    public static void outputArrayList(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println(arrayList.get(i));
        }
    }

    public static void outputShortestPath(HashMap<String, LinkedList<TestAction>> shortestPath) {
        Set<String> key = shortestPath.keySet();
        for (String ac : key) {
            LinkedList<TestAction> actions = shortestPath.get(ac);
            System.out.println("\u74ba\ue21a\u7dde\u951b\ufffd " + ac);
            for (int i = 0; i < actions.size(); ++i) {
                System.out.println(actions.get(i));
            }
        }
    }

    public static ArrayList<BugDetail> getBugDetail(String data) {
        JSONArray jsonArray = JSONArray.parseArray((String)data);
        ArrayList<BugDetail> bugDetails = new ArrayList<BugDetail>();
        HashSet<BugDetail> set = new HashSet<BugDetail>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            BugDetail temp = (BugDetail)JSON.parseObject((String)jsonArray.get(i).toString(), BugDetail.class);
            if (!action.bugFilter((BugDetail)temp) || set.contains(temp)) continue;
            bugDetails.add(temp);
            set.add(temp);
        }
        return bugDetails;
    }

    public static boolean bugFilter(BugDetail bugDetail) {
        return !bugDetail.bugInfo.content.contains("Error opening trace file: No such file or directory") && !bugDetail.bugInfo.component.contains("QueryController") && !bugDetail.bugInfo.content.contains("Skipping invisible child") && !bugDetail.bugInfo.content.contains("Matched selector");
    }

    public static ArrayList<String> getScreenShots(String path) throws IOException {
        File file = new File(path);
        ArrayList<String> result = new ArrayList<String>();
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                result.add(files[i].getName());
            }
            return result;
        }
        throw new IOException(path + "is not a Directory");
    }

    public static String dateToStamp(String s, String format) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date date = simpleDateFormat.parse(s);
        long ts = date.getTime();
        String res = String.valueOf(ts);
        return res;
    }

    public static void addScreenShot(ArrayList<TestAction> testActions, ArrayList<String> screenShots) throws ParseException {
        block0: for (int i = 0; i < testActions.size(); ++i) {
            TestAction testAction = testActions.get(i);
            String time = action.dateToStamp((String)testAction.timeBeforeAction, (String)"yyyy-MM-dd HH:mm:ss,SSS");
            for (int j = 0; j < screenShots.size(); ++j) {
                String temp = screenShots.get(j).split("_")[1].split("\\.")[0];
                if (Long.parseLong(time) - 0L > Long.parseLong(temp)) continue;
                testAction.screenShot = new ArrayList();
                if (j - 1 >= 0) {
                    testAction.screenShot.add(screenShots.get(j - 1));
                }
                testAction.screenShot.add(screenShots.get(j));
                if (j + 1 >= screenShots.size()) continue block0;
                testAction.screenShot.add(screenShots.get(j + 1));
                continue block0;
            }
        }
    }

    public static ArrayList<Task> getTasks(ArrayList<BugDetail> bugDetails, HashMap<String, LinkedList<TestAction>> shortestPath, boolean flag) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        for (int i = 0; i < bugDetails.size(); ++i) {
            Task task = new Task();
            BugDetail temp = bugDetails.get(i);
            task.currentActivity = temp.currentActivity;
            Set<String> set = shortestPath.keySet();
            Iterator<String> iterator = set.iterator();
            task.steps = new LinkedList();
            while (iterator.hasNext()) {
                String activity = iterator.next();
                if (!activity.contains(temp.currentActivity)) continue;
                task.steps = shortestPath.get(activity);
            }
            task.bugContent = temp.bugInfo.content;
            task.bugScreenShot = temp.bugInfo.screenShot;
            task.deviceInfo = temp.deviceInfo;
            tasks.add(task);
        }
        return tasks;
    }

    public static ArrayList<ExceptionDesc> getExceptionDesc(String data) {
        JSONArray jsonArray = JSONArray.parseArray((String)data);
        ArrayList<ExceptionDesc> exceptionDescs = new ArrayList<ExceptionDesc>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            ExceptionDesc exceptionDesc = (ExceptionDesc)JSON.parseObject((String)jsonArray.get(i).toString(), ExceptionDesc.class);
            exceptionDescs.add(exceptionDesc);
        }
        return exceptionDescs;
    }

    public static void addBugDesc(ArrayList<ExceptionDesc> exceptionDescs, ArrayList<Task> tasks) {
        for (int i = 0; i < tasks.size(); ++i) {
            Task task = tasks.get(i);
            for (int j = 0; j < exceptionDescs.size(); ++j) {
                if (!task.bugContent.contains(exceptionDescs.get((int)j).name)) continue;
                task.bugDesc = exceptionDescs.get((int)j).zh;
            }
            if (task.bugDesc != null && task.bugDesc != "") continue;
            task.bugDesc = "\u95c8\u6fe7ndroid\u7459\ufe40\u5f42\u9428\u52eb\u7d13\u752f\u9769\u7d1d\u9359\ue21d\u5158\u9422\u53d8\u7c2c\u7ed7\ue0ff\u7b01\u93c2\u7470\u7c31\u93b4\u682c\ufffd\u546d\u53fe\u7039\u51a8\u5e2b\u9365\u72c5\u7d1d\u7487\u7a27oogle\u93cc\u30e8\ue1d7\u9286\ufffd";
        }
    }

    public static void writeData(String path, String data) {
        File file = new File(path);
        FileWriter out = null;
        try {
            out = new FileWriter(file);
            out.write(data);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("File path,Please!");
            return;
        }
        System.out.println("Argument is \u951b\ufffd" + args[0]);
        ArrayList result = new ArrayList();
        String fileTarget = "./tasks/" + args[0];
        File file = new File(fileTarget);
        File[] files = file.listFiles();
        HashMap map = new HashMap();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            ArrayList bugDetails = new ArrayList();
            map.put(files[i].getName(), bugDetails);
        }
        ArrayList bugDetails = action.getBugDetail((String)action.readTestData((String)(fileTarget + "/bugList.json")));
        for (int i = 0; i < bugDetails.size(); ++i) {
            String udid = ((BugDetail)bugDetails.get((int)i)).deviceInfo.udid;
            ArrayList temp = (ArrayList)map.get(udid);
            temp.add(bugDetails.get(i));
        }
        Set keys = map.keySet();
        for (String device : keys) {
            ArrayList deviceBugDetails = (ArrayList)map.get(device);
            if (deviceBugDetails.size() < 1) continue;
            String basePath = fileTarget + "/" + device + "/";
            ArrayList testActions = action.getTestAction((String)action.readTestData((String)(basePath + "TestAction.log")));
            ArrayList screenShots = action.getScreenShots((String)(basePath + "ScreenShots"));
            action.addScreenShot((ArrayList)testActions, (ArrayList)screenShots);
            ArrayList activities = action.getAppActivity((ArrayList)testActions);
            HashMap shortestPath = (HashMap)action.getShortestPath((ArrayList)activities, (ArrayList)testActions);
            ArrayList tasks = action.getTasks((ArrayList)deviceBugDetails, (HashMap)shortestPath, (boolean)true);
            ArrayList exceptionDescs = action.getExceptionDesc((String)action.readTestData((String)"./tasks/ExceptionType.json"));
            action.addBugDesc((ArrayList)exceptionDescs, (ArrayList)tasks);
            for (int j = 0; j < tasks.size(); ++j) {
                result.add(tasks.get(j));
            }
        }
        String s = JSON.toJSONString(result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        Long timeStamp = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String sd = sdf.format(new Date(Long.parseLong(String.valueOf(timeStamp))));
        String filePath = fileTarget + "/bb2h.json";
        System.out.println("\u9422\u71b8\u579a\u9428\u52ec\u6783\u6d60\u60f0\u77fe\u5bf0\ufffd" + filePath);
        action.writeData((String)filePath, (String)s);
    }
}

